* write out a time series of an avgeraged area in ASCII.
* time and space interval has to be set in grads first
*
* USAGE: run wrseries filename fld firstdate [-ovy]
* where 
*   fld:   grads expressions
*    -ov:   option for output of the data to screen.
*    -oy:   scale time step by 1/12
*    -ovy:   both -ov and -oy
*
*
* Example: run wrseries datafile.txt zeta 1 100
*
*
*	authors: muennich & dommenget
*
function wrseries(arg)
file=subwrd(arg,1)
fld=subwrd(arg,2)
if( fld='' )
say ''
say ' USAGE: run wrseries filename fld firstdate [-ovy]'
say ' where '
say '   fld:   grads expressions'
say '    -ov:   option for output of the data to screen.'
say '    -oy:   scale time step by 1/12'
say '    -ovy:   both -ov and -oy'
say ''
say ' NOTE: The space units must be set to one data point!'
say ''
say ' Example: run wrseries datafile.txt zeta 1 -oy'
say ''
return
endif
date=subwrd(arg,3)
if(date= '')
   date=0
endif
vrbos=subwrd(arg,4)
yrbos=subwrd(arg,4)
vopt=''
yopt=''
if(vrbos= '-ov')
   vopt='v'
endif
if(vrbos= '-oy')
   yopt='y'
endif
if(vrbos= '-ovy')
   yopt='y'
   vopt='v'
endif
if(vrbos= '-oyv')
   yopt='y'
   vopt='v'
endif

gxstate()
say '     writing 'fld' for '_ts'<=t<='_te' to 'file'.'
say ' dim:   LON: '_lons' - '_lone
say '        LAT: '_lats' - '_late
say '       TIME: '_tims' - '_time

tt=_ts
'!rm -f 'file

while (tt <= _te)
   'set t 'tt
   time=tt
   if(yopt='y')
     time=tt/12
   endif
   if (_xs=_xe & _ys=_ye )
*     say 'one point'
     'd 'fld
   else
*     say 'multi points'
     'd aave('fld',x='_xs',x='_xe',y='_ys',y='_ye')'
   endif
   yy=subwrd(result,4)
   time=time+date
   if(vopt='v')
      say '  'fld'('time')='yy
   endif
   good=write(file,time' 'yy,append)
   tt=tt + 1
endwhile
'set t '_ts' '_te
return

******************************************************
******************************************************
function gxstate()
*
*  Get dimension information as global var _xs,_xe,...
*
'query dim'
dinf = result
lx = sublin(dinf,2)
ly = sublin(dinf,3)
lz = sublin(dinf,4)
lt = sublin(dinf,5)
if ( subwrd(lx,7) = 'to')
  _lons = subwrd(lx,6)
  _lone = subwrd(lx,8)
  _xs = subwrd(lx,11)
  _xe = subwrd(lx,13)
else
  _lons = subwrd(lx,6)
  _lone = subwrd(lx,6)
  _xs = subwrd(lx,9)
  _xe = subwrd(lx,9)
endif
if ( subwrd(ly,7) = 'to')
  _lats = subwrd(ly,6)
  _late = subwrd(ly,8)
  _ys = subwrd(ly,11)
  _ye = subwrd(ly,13)
else
  _lats = subwrd(ly,6)
  _late = subwrd(ly,6)
  _ys = subwrd(ly,9)
  _ye = subwrd(ly,9)
endif
if ( subwrd(lz,7) = 'to')
  _levs = subwrd(lz,6)
  _leve = subwrd(lz,8)
  _zs = subwrd(lz,11)
  _ze = subwrd(lz,13)
else
  _levs = subwrd(lz,6)
  _leve = subwrd(lz,6)
  _zs = subwrd(lz,9)
  _ze = subwrd(lz,9)
endif
if ( subwrd(lt,7) = 'to')
  _tims = subwrd(lt,6)
  _time = subwrd(lt,8)
  _ts = subwrd(lt,11)
  _te = subwrd(lt,13)
else
  _tims = subwrd(lt,6)
  _time = subwrd(lt,6)
  _ts = subwrd(lt,9)
  _te = subwrd(lt,9)
endif
return
******************************************************
*****************************************************
