
begin

 spinup_date  = "2018-10-01"
 spinup_path  = "/scratch1/NCEPDEV/global/Helin.Wei/hr4_land/ufs-land-driver/run/spinup_C768"
 clipped_path = "/scratch2/NCEPDEV/land/Youlong.Xia/landDA/era5_ICS/C768/mem000/restarts/vector"

 spinup_filename = spinup_path+"/ufs_land_restart."+spinup_date+"_00-00-00.nc"
 change_filename = clipped_path+"/ufs_land_restart.clipped."+spinup_date+"_00-00-00.nc"

 print("copying "+spinup_filename+" to "+change_filename)
 system("cp "+spinup_filename+" "+change_filename)

 spinup_file = addfile(spinup_filename,"r")
 change_file = addfile(change_filename,"w")

 spinsnd = spinup_file->snow_depth
 spinswe = spinup_file->snow_water_equiv
 
 do iloc = 1, dimsizes(spinsnd(0,:))   ; put some limits on snow

   if(iloc%1000.eq.0) then
     print("Checking location: "+iloc)
   end if

   if(spinsnd(0,iloc-1).gt.2000.) then
     reduction_factor = 2000.0/spinsnd(0,iloc-1)
     print("Reducing location "+iloc+" with depth = "+spinsnd(0,iloc-1)+" by factor = "+reduction_factor)
     spinsnd(0,iloc-1) = 2000.0
     spinswe(0,iloc-1) = reduction_factor * spinswe(0,iloc-1)
   end if

   if((spinsnd(0,iloc-1).gt.0. .and. spinsnd(0,iloc-1).lt.1.) .or. \
      (spinswe(0,iloc-1).gt.0. .and. spinswe(0,iloc-1).lt.0.01)) then
     print("Removing location "+iloc+" with SWE = "+spinswe(0,iloc-1)+" and depth = "+spinsnd(0,iloc-1))
     spinsnd(0,iloc-1) = 0.0
     spinswe(0,iloc-1) = 0.0
   end if

 end do

print(dimsizes(spinsnd))
print(dimsizes(spinswe))

print(dimsizes(change_file->snow_depth))
print(dimsizes(change_file->snow_water_equiv))

 change_file->snow_depth       = (/ spinsnd /)
 change_file->snow_water_equiv = (/ spinswe /)

end

