
begin

print_high_snow_removal = True
print_low_snow_removal = False

sfcdata_path = "/scratch1/NCEPDEV/stmp2/Helin.Wei/spinup/cycle/C384/sfc_data/gfs."
spinup_path  = "/scratch2/NCEPDEV/stmp1/Youlong.Xia/landDA/cycle_land/C384/DA_GHCN_HR4/mem000/restarts/vector"

pathchar = tochar(sfcdata_path)
pathlength = dimsizes(pathchar)

dirs_to_process = systemfunc("ls -d "+sfcdata_path+"*")
numdates = dimsizes(dirs_to_process)
print("Processing "+numdates+" dates")

vegetation_file = addfile("/scratch2/NCEPDEV/land/Michael.Barlage/forcing/C384/vector/ufs-land_C384_hr3_static_fields.nc","r")
vegetation_type = vegetation_file->vegetation_category

do idate = 0, numdates - 1

date_to_process = tochar(dirs_to_process(idate))
datestring = tostring(date_to_process(pathlength:pathlength+7))

  sfc_date = datestring
 spin_date = ""+date_to_process(pathlength:pathlength+3)+"-"+date_to_process(pathlength+4:pathlength+5)+"-"+date_to_process(pathlength+6:pathlength+7)

 print("Moving: "+spin_date+" to "+sfc_date)

 spinup_file = addfile(spinup_path+"/ufs_land_restart_anal."+spin_date+"_00-00-00.nc","r")

 spinsmc = spinup_file->soil_moisture_vol(0,:,:)
 spinslc = spinup_file->soil_liquid_vol(0,:,:)
 spinstc = spinup_file->temperature_soil(0,:,:)
 spinsnd = spinup_file->snow_depth(0,:)
 spinswe = spinup_file->snow_water_equiv(0,:)
 
 high_snow_removal = 0
 low_snow_removal = 0
 
 do iloc = 1, dimsizes(spinsnd)   ; put some limits on snow

   if(spinsnd(iloc-1).gt.2000. .and. vegetation_type(iloc-1).eq.15) then
     reduction_factor = 2000.0/spinsnd(iloc-1)
     if(print_high_snow_removal) then
       print("Reducing glacier location with depth = "+spinsnd(iloc-1)+" by factor = "+reduction_factor)
     end if
     spinsnd(iloc-1) = 2000.0
     spinswe(iloc-1) = reduction_factor * spinswe(iloc-1)
     high_snow_removal = high_snow_removal + 1
   end if

   if(spinsnd(iloc-1).gt.10000.) then
     reduction_factor = 10000.0/spinsnd(iloc-1)
     if(print_high_snow_removal) then
       print("Reducing non-glacier location with depth = "+spinsnd(iloc-1)+" by factor = "+reduction_factor)
     end if
     spinsnd(iloc-1) = 10000.0
     spinswe(iloc-1) = reduction_factor * spinswe(iloc-1)
     high_snow_removal = high_snow_removal + 1
   end if

   if((spinsnd(iloc-1).gt.0. .and. spinsnd(iloc-1).lt.1.) .or. \
      (spinswe(iloc-1).gt.0. .and. spinswe(iloc-1).lt.0.01)) then
     if(print_low_snow_removal) then
       print("Removing location with SWE = "+spinswe(iloc-1)+" and depth = "+spinsnd(iloc-1))
     end if
     spinsnd(iloc-1) = 0.0
     spinswe(iloc-1) = 0.0
     low_snow_removal = low_snow_removal + 1
   end if

 end do
 
num_in_spinup = dimsizes(spinstc(0,:))
print("Num in spinup: "+ num_in_spinup)
print("Num high_snow_removal: "+ high_snow_removal)
print("Num low_snow_removal: "+ low_snow_removal)

nloc = -1

do itile = 1,6

 print("Starting tile: "+itile)

 sfcdata_file = addfile(sfcdata_path+sfc_date+"/sfc_data.tile"+itile+".nc","w")

 inmask = sfcdata_file->vtype(0,:,:)

 sfcsmc = sfcdata_file->smc
 sfcslc = sfcdata_file->slc
 sfcstc = sfcdata_file->stc
 sfcswe = sfcdata_file->weasdl
 sfcsnd = sfcdata_file->snodl
 
 ndims = dimsizes(inmask)
 print("Num vtype /= 0: "+ num(inmask.gt.0))

 do idim0 = 0, ndims(0)-1
 do idim1 = 0, ndims(1)-1
 
   if(inmask(idim0,idim1).ne.0) then
     nloc = nloc + 1
     
   ; Ensure the assignment matches the dimensions (10 layers)
   ; printVarSummary(spinsmc(:, nloc))
   ; printVarSummary(sfcsmc(0,:,idim0, idim1))
     sfcsmc(0,:,idim0,idim1) = (/ spinsmc(:,nloc) /)
     sfcslc(0,:,idim0,idim1) = (/ spinslc(:,nloc) /)
     sfcstc(0,:,idim0,idim1) = (/ spinstc(:,nloc) /)
     sfcswe(0,idim0,idim1)   = (/ spinswe(nloc) /)
     sfcsnd(0,idim0,idim1)   = (/ spinsnd(nloc) /)
     
   end if
   
 end do
 end do
 
 num_in_tiles = nloc+1
 print("number of cumulative locs: "+num_in_tiles)

 sfcdata_file->smc = (/sfcsmc/)
 sfcdata_file->slc = (/sfcslc/)
 sfcdata_file->stc = (/sfcstc/)
 sfcdata_file->weasdl = (/sfcswe/)
 sfcdata_file->snodl = (/sfcsnd/)
 
 delete(sfcsmc)
 delete(sfcslc)
 delete(sfcstc)
 delete(sfcswe)
 delete(sfcsnd)
 delete(inmask)
 
end do  ; tile loop

 if(num_in_tiles .ne. num_in_spinup) then
  print("number in tiles /= number in spinup")
  exit
 end if

end do  ; date loop

end

