begin

print_high_snow_removal = True
print_low_snow_removal = False

sfcdata_path = "/scratch1/NCEPDEV/stmp2/Helin.Wei/spinup/hr4/C768/test14/gfs."
spinup_path  = "/scratch1/NCEPDEV/global/Helin.Wei/save/git/sync/ufs_land_soil_new/ufs-land-driver/run/examples/C96.hera/spinup_C768"

pathchar = tochar(sfcdata_path)
pathlength = dimsizes(pathchar)

dirs_to_process = systemfunc("ls -d "+sfcdata_path+"*")
numdates = dimsizes(dirs_to_process)
print("Processing "+numdates+" dates")

vegetation_file = addfile("/scratch2/NCEPDEV/land/Michael.Barlage/forcing/C768/vector/ufs-land_C768_hr3_static_fields.nc","r")
vegetation_type = vegetation_file->vegetation_category

do idate = 0, numdates - 1

    date_to_process = tochar(dirs_to_process(idate))
    datestring = tostring(date_to_process(pathlength:pathlength+7))

    sfc_date = datestring
    spin_date = date_to_process(pathlength:pathlength+3) + "-" + date_to_process(pathlength+4:pathlength+5) + "-" + date_to_process(pathlength+6:pathlength+7)

    print("Moving: " + spin_date + " to " + sfc_date)

    spinup_file = addfile(spinup_path + "/ufs_land_restart." + spin_date + "_00-00-00.nc", "r")

    ; Read the 3D variables with dimensions [time, soil_levels, location]
    spinsmc = spinup_file->soil_moisture_vol(0, :, :)
    spinslc = spinup_file->soil_liquid_vol(0, :, :)
    spinstc = spinup_file->temperature_soil(0, :, :)
    spinsnd = spinup_file->snow_depth(0, :)
    spinswe = spinup_file->snow_water_equiv(0, :)

    high_snow_removal = 0
    low_snow_removal = 0

    do iloc = 0, dimsizes(spinsnd) - 1

        if (spinsnd(iloc) .gt. 2000 .and. vegetation_type(iloc) .eq. 15) then
            reduction_factor = 2000.0 / spinsnd(iloc)
            if (print_high_snow_removal) then
                print("Reducing glacier location with depth = " + spinsnd(iloc) + " by factor = " + reduction_factor)
            end if
            spinsnd(iloc) = 2000.0
            spinswe(iloc) = reduction_factor * spinswe(iloc)
            high_snow_removal = high_snow_removal + 1
        end if

        if (spinsnd(iloc) .gt. 10000.) then
            reduction_factor = 10000.0 / spinsnd(iloc)
            if (print_high_snow_removal) then
                print("Reducing non-glacier location with depth = " + spinsnd(iloc) + " by factor = " + reduction_factor)
            end if
            spinsnd(iloc) = 10000.0
            spinswe(iloc) = reduction_factor * spinswe(iloc)
            high_snow_removal = high_snow_removal + 1
        end if

        if ((spinsnd(iloc) .gt. 0 .and. spinsnd(iloc) .lt. 1.) .or. \
            (spinswe(iloc) .gt. 0 .and. spinswe(iloc) .lt. 0.01)) then
            if (print_low_snow_removal) then
                print("Removing location with SWE = " + spinswe(iloc) + " and depth = " + spinsnd(iloc))
            end if
            spinsnd(iloc) = 0.0
            spinswe(iloc) = 0.0
            low_snow_removal = low_snow_removal + 1
        end if

    end do

    num_in_spinup = dimsizes(spinstc(0, :))
    print("Num in spinup: " + tostring(num_in_spinup))
    print("Num high_snow_removal: " + tostring(high_snow_removal))
    print("Num low_snow_removal: " + tostring(low_snow_removal))

    nloc = -1
    do itile = 1, 6

        print("Starting tile: " + tostring(itile))

        sfcdata_filename = sfcdata_path + sfc_date + "/sfc_data.tile" + tostring(itile) + ".nc"

; change zaxis_1 to a record dimension so it can be increased

        system("ncks -h -O --mk_rec_dmn zaxis_1 "+sfcdata_filename+" "+sfcdata_filename)

        sfcdata_file = addfile(sfcdata_filename, "w")

        inmask = sfcdata_file->vtype(0, :, :)

        ndims = dimsizes(inmask)
        print("Num vtype /= 0: " + tostring(num(inmask .gt. 0)))

        sfcsmc = new((/1,10,ndims(0),ndims(1)/),double)
         sfcsmc!0 = "Time"
         sfcsmc!1 = "zaxis_1"
         sfcsmc!2 = "yaxis_1"
         sfcsmc!3 = "xaxis_1"
           sfcsmc@long_name = "smc"
           sfcsmc@units = "none"
           sfcsmc@coordinates = "geolon geolat"
        sfcslc = sfcsmc
           sfcslc@long_name = "slc"
           sfcslc@units = "none"
           sfcslc@coordinates = "geolon geolat"
        sfcstc = sfcsmc
           sfcstc@long_name = "stc"
           sfcstc@units = "none"
           sfcstc@coordinates = "geolon geolat"
        zaxis_1 = new(10,float)
           zaxis_1!0 = "zaxis_1"
           zaxis_1@long_name = "zaxis_1" ;
           zaxis_1@units = "none" ;
           zaxis_1@cartesian_axis = "Z" ;

        zaxis_1 = ispan(1, 10, 1)  ; Update zaxis_1 to have 10 layers

        ; Adjust the surface data variables to have 10 layers
        sfcsmc(0,0:3,:,:) = sfcdata_file->smc(0, 0:3, :, :)  ; grab the first layer for non-land filling
        sfcslc(0,0:3,:,:) = sfcdata_file->slc(0, 0:3, :, :)  ; soil fields are 4D
        sfcstc(0,0:3,:,:) = sfcdata_file->stc(0, 0:3, :, :)
        do ilev = 4,9
          sfcsmc(0,ilev,:,:) = sfcsmc(0,0,:,:) ; fill the new layers with layer 1
          sfcslc(0,ilev,:,:) = sfcslc(0,0,:,:) ; this is for non-land grids
          sfcstc(0,ilev,:,:) = sfcstc(0,0,:,:) 
        end do

        sfcswe = sfcdata_file->sheleg(0, :, :)   ; snow fields are 2D
        sfcsnd = sfcdata_file->snwdph(0, :, :)

        do idim0 = 0, ndims(0) - 1
        do idim1 = 0, ndims(1) - 1

            if (inmask(idim0, idim1) .ne. 0) then
                nloc = nloc + 1

                sfcsmc(0,:,idim0,idim1) = (/ spinsmc(:,nloc) /)
                sfcslc(0,:,idim0,idim1) = (/ spinslc(:,nloc) /)
                sfcstc(0,:,idim0,idim1) = (/ spinstc(:,nloc) /)
                sfcswe(idim0,idim1)   = (/ spinswe(nloc) /)
                sfcsnd(idim0,idim1)   = (/ spinsnd(nloc) /)

            end if

        end do
        end do

        num_in_tiles = nloc + 1
        print("number of cumulative locs: " + tostring(num_in_tiles))

        ; Assign the updated variables back to the surface data file
        sfcdata_file->zaxis_1 = (/ zaxis_1 /)
        sfcdata_file->smc = (/ sfcsmc /)
        sfcdata_file->slc = (/ sfcslc /)
        sfcdata_file->stc = (/ sfcstc /)
        sfcdata_file->sheleg(0, :, :) = (/ sfcswe /)
        sfcdata_file->snwdph(0, :, :) = (/ sfcsnd /)

        delete(sfcdata_file)
        delete(sfcsmc)
        delete(sfcslc)
        delete(sfcstc)
        delete(sfcswe)
        delete(sfcsnd)
        delete(inmask)

; remove the record dimension
        system("ncks -h -O --fix_rec_dmn zaxis_1 "+sfcdata_filename+" "+sfcdata_filename)

    end do  ; tile loop

    if(num_in_tiles .ne. num_in_spinup) then
        print("number in tiles /= number in spinup")
        exit
    end if

end do  ; date loop

end
