begin

  res                       = True              ; Plot mods desired.
  res@gsnMaximize           = True              ; Maximize plot
  res@gsnAddCyclic          = False             ; don't add a longitude cyclic point
  res@cnFillOn              = True              ; color plot desired
  res@cnFillOpacityF        = 0.6               ; apply a little opacity so we can see mesh lines better
  res@cnFillMode            = "CellFill"
  res@cnFillPalette         = "BlWhRe"
  res@cnLinesOn             = False             ; turn off contour lines
  res@cnLineLabelsOn        = False             ; turn off contour labels
  res@tiMainFontHeightF     = 0.017
  res@pmTitleZone           = 4                 ; move title down
  res@mpFillOn              = False             ; turn off map fill
  res@pmTickMarkDisplayMode = "Always"          ; nicer map tickmark labels
  res@mpDataBaseVersion     = "LowRes"       ; better map outlines
  res@mpOutlineBoundarySets = "Geophysical"
  res@mpOutlineOn           = True
  res@mpNationalLineThicknessF    = 2.0      ; for better looking images
  res@mpGeophysicalLineThicknessF = 2.0
  res@mpCountyLineThicknessF      = 2.0
  res@mpProvincialLineThicknessF  = 2.0
  res@gsnRightString        = ""
  res@gsnLeftString         = ""
  res@lbLabelBarOn          = True             ; Will turn on in panel

  if(True) then
    wks = gsn_open_wks("x11","blah") 
  else
    wks = gsn_open_wks("png","blah") 
  end if

  infile = addfile("/scratch2/NCEPDEV/land/data/ufs-land-driver/vector_inputs/C768.mx025/ufs-land_C768.mx025_hr3_corners.nc","r")
  
  lat  = infile->latitude
  lon  = infile->longitude
  latc = infile->latitude_corners
  lonc = infile->longitude_corners

  res@sfXArray      := lon               ; necessary for plotting MPAS
  res@sfYArray      := lat
  res@sfYCellBounds := latc     ; necessary for CellFill 
  res@sfXCellBounds := lonc

  c768_filename = "C768/ufs_land_restart_anal.2019-12-03_00-00-00.nc"
  infile = addfile(c768_filename,"r")
  temperature_ground = infile->temperature_ground(0,:)
  temperature_radiative = infile->temperature_radiative(0,:)
  temperature_soil = infile->temperature_soil(0,0,:)
  snow_levels = infile->active_snow_levels(0,:)
  snow_levels_lookup = tointeger(snow_levels)
  snow_levels_lookup = 0
  snow_levels_lookup = where(snow_levels.eq.-3,0,snow_levels_lookup)
  snow_levels_lookup = where(snow_levels.eq.-2,1,snow_levels_lookup)
  snow_levels_lookup = where(snow_levels.eq.-1,2,snow_levels_lookup)
  temperature_snow_in = infile->temperature_snow(0,:,:)
  temperature_snow = temperature_snow_in(0,:)
  do i=0,1067332
    temperature_snow(i) = (/ temperature_snow_in(snow_levels_lookup(i),i) /)
  end do
  temperature_snow = mask(temperature_snow,snow_levels.lt.0,True)

  temperature_difference = temperature_radiative - temperature_soil
  temperature_difference = mask(temperature_difference,snow_levels.lt.0,True)

  plot = gsn_csm_contour_map(wks,temperature_difference,res)  

end
