#!/bin/sh -l
#
# -- Request n cores
#SBATCH --ntasks=2
#
# -- Specify queue
#SBATCH -q debug
#
# -- Specify a maximum wallclock
#SBATCH --time=0:05:00
#
# -- Specify under which account a job should run
#SBATCH --account=fv3-cpu
#
# -- Set the name of the job, or Slurm will default to the name of the script
#SBATCH --job-name=regrid_weights
#
# -- Tell the batch system to set the working directory to the current working directory
#SBATCH --chdir=.

nt=$SLURM_NTASKS

module purge
module use /scratch1/NCEPDEV/nems/role.epic/spack-stack/spack-stack-1.5.1/envs/unified-env-rocky8/install/modulefiles/Core
module load stack-intel/2021.5.0
module load stack-intel-oneapi-mpi/2021.5.1
module load esmf/8.5.0

srun -n $nt ESMF_RegridWeightGen --netcdf4 --ignore_degenerate \
       --source /scratch2/NCEPDEV/land/data/ufs-land-driver/vector_inputs/C384.mx025/ufs-land_C384.mx025_hr3_SCRIP.nc \
       --destination /scratch2/NCEPDEV/land/data/ufs-land-driver/vector_inputs/C192.mx025/ufs-land_C192.mx025_hr3_SCRIP.nc \
       --weight C384.mx025-C192.mx025_hr3_nearest_wts.nc \
       --method neareststod  --extrap_method neareststod

srun -n $nt ESMF_RegridWeightGen --netcdf4 --ignore_degenerate \
       --source /scratch2/NCEPDEV/land/data/ufs-land-driver/vector_inputs/C384.mx025/ufs-land_C384.mx025_hr3_SCRIP_veg.nc \
       --destination /scratch2/NCEPDEV/land/data/ufs-land-driver/vector_inputs/C192.mx025/ufs-land_C192.mx025_hr3_SCRIP_veg.nc \
       --weight C384.mx025-C192.mx025_hr3_veg_nearest_wts.nc \
       --method neareststod  --extrap_method neareststod

srun -n $nt ESMF_RegridWeightGen --netcdf4 --ignore_degenerate \
       --source /scratch2/NCEPDEV/land/data/ufs-land-driver/vector_inputs/C384.mx025/ufs-land_C384.mx025_hr3_SCRIP_bare.nc \
       --destination /scratch2/NCEPDEV/land/data/ufs-land-driver/vector_inputs/C192.mx025/ufs-land_C192.mx025_hr3_SCRIP_bare.nc \
       --weight C384.mx025-C192.mx025_hr3_bare_nearest_wts.nc \
       --method neareststod  --extrap_method neareststod

srun -n $nt ESMF_RegridWeightGen --netcdf4 --ignore_degenerate \
       --source /scratch2/NCEPDEV/land/data/ufs-land-driver/vector_inputs/C384.mx025/ufs-land_C384.mx025_hr3_SCRIP_snow.nc \
       --destination /scratch2/NCEPDEV/land/data/ufs-land-driver/vector_inputs/C192.mx025/ufs-land_C192.mx025_hr3_SCRIP_snow.nc \
       --weight C384.mx025-C192.mx025_hr3_snow_nearest_wts.nc \
       --method neareststod  --extrap_method neareststod

