; see /scratch2/NCEPDEV/land/Michael.Barlage/forcing/README for generating the weights files

load "$NCARG_ROOT/lib/ncarg/nclscripts/esmf/ESMF_regridding.ncl"

begin

weights_nearest      = "/scratch2/NCEPDEV/land/Michael.Barlage/forcing/datasets/restart_regrid/C768-C1152/hr3/C768-C1152_hr3_nearest_wts.nc"
weights_nearest_veg  = "/scratch2/NCEPDEV/land/Michael.Barlage/forcing/datasets/restart_regrid/C768-C1152/hr3/C768-C1152_hr3_veg_nearest_wts.nc"
weights_nearest_bare = "/scratch2/NCEPDEV/land/Michael.Barlage/forcing/datasets/restart_regrid/C768-C1152/hr3/C768-C1152_hr3_bare_nearest_wts.nc"
weights_nearest_snow = "/scratch2/NCEPDEV/land/Michael.Barlage/forcing/datasets/restart_regrid/C768-C1152/hr3/C768-C1152_hr3_snow_nearest_wts.nc"

inname = "/scratch2/NCEPDEV/land/data/forcing/era5/static/C1152/ufs-land_C1152_hr3_static_fields.nc"
infile = addfile(inname,"r")
vegtype = infile->vegetation_category

filenames = systemfunc("ls *.nc")
print(dimsizes(filenames))

do idate = 0, 169

datechars = stringtochar(filenames(idate))
datestring = datechars(16:25)

print("Starting: "+datestring)

C768_filename  = "../C768/ufs_land_restart_anal."+datestring+"_00-00-00.nc"
C1152_filename = "ufs_land_output."+datestring+"_00-00-00.nc"

infile = addfile(C768_filename,"r")

outfile = addfile(C1152_filename,"w")

Opt = True

invars = (/"snow_depth","snow_water_equiv"/)
do ivar = 0, 1

  print("Processing: "+invars(ivar))
  invar = infile->$invars(ivar)$

  outvar      = ESMF_regrid_with_weights(invar,weights_nearest,Opt)
  outvar_veg  = ESMF_regrid_with_weights(invar,weights_nearest_veg,Opt)
  outvar_bare = ESMF_regrid_with_weights(invar,weights_nearest_bare,Opt)
  outvar_snow = ESMF_regrid_with_weights(invar,weights_nearest_snow,Opt)

  print(num(outvar(0,:) .gt. 1e19))
  print(num(outvar(0,:) .gt. 1e19 .and. (vegtype.ne.15.and.vegtype.ne.16)))
  print(num(outvar(0,:) .gt. 1e19 .and. (vegtype.eq.15)))
  print(num(outvar(0,:) .gt. 1e19 .and. (vegtype.eq.16)))

  outvar(0,:) = where(vegtype.ne.15 .and. vegtype.ne.16, outvar_veg(0,:), outvar(0,:))
  outvar(0,:) = where(vegtype.eq.15, outvar_snow(0,:), outvar(0,:))
  outvar(0,:) = where(vegtype.eq.16, outvar_bare(0,:), outvar(0,:))

  print(num(outvar(0,:) .gt. 1e19))
  print(num(outvar(0,:) .gt. 1e19 .and. (vegtype.ne.15.and.vegtype.ne.16)))
  print(num(outvar(0,:) .gt. 1e19 .and. (vegtype.eq.15)))
  print(num(outvar(0,:) .gt. 1e19 .and. (vegtype.eq.16)))

  outfile->$invars(ivar)$ = (/ tofloat(outvar) /)

  delete(invar)
  delete(outvar)
  delete(outvar_veg)
  delete(outvar_bare)
  delete(outvar_snow)

end do

end do

end

