; see /scratch2/NCEPDEV/land/Michael.Barlage/forcing/README for generating the weights files

load "$NCARG_ROOT/lib/ncarg/nclscripts/esmf/ESMF_regridding.ncl"

begin

weights_nearest      = "C96-C768_nearest_wts.nc"
weights_nearest_veg  = "C96-C768_veg_nearest_wts.nc"
weights_nearest_bare = "C96-C768_bare_nearest_wts.nc"
weights_nearest_snow = "C96-C768_snow_nearest_wts.nc"

; These variable have some missing values over glacial/bare areas that might cause a problem.
;(9)     leaf_area_index
;(10)    stem_area_index
;(21)    canopy_wet_fraction
;(23)    depth_water_table
;(32)    temperature_canopy_air
;(34)    temperature_leaf
;(36)    vapor_pres_canopy_air
;(42)    canopy_liquid
;(43)    canopy_ice
;(44)    aquifer_water
;(45)    saturated_water
;(46)    lake_water
;(49)    leaf_carbon
;(50)    root_carbon
;(51)    stem_carbon
;(52)    wood_carbon
;(53)    soil_carbon_stable
;(54)    soil_carbon_fast
;(59)    transpiration_heat
;(60)    latent_heat_canopy
;(64)    precip_adv_heat_total

special_variables = (/9,10,21,23,32,34,36,42,43,44,45,46,49,50,51,52,53,54,59,60,64/)

inname = "/scratch2/NCEPDEV/land/data/forcing/era5/static/ufs-land_C768_static_fields_hr2.nc"
infile = addfile(inname,"r")
vegtype = infile->vegetation_category

inname = "/scratch2/NCEPDEV/land/Michael.Barlage/spinup_hr2/ufs-land-driver/run/spinup_C96/ufs_land_restart.2010-01-01_00-00-00.nc"
infile = addfile(inname,"r")
invars = getfilevarnames(infile)
;print(invars)
;exit

outname = "ufs_land_restart.C96-C768.2010-01-01_00-00-00.nc"
 system("if [ -e "+outname+" ]; then rm -f "+outname+ ";fi")
outfile = addfile(outname,"c")

outfile->time = infile->time
outfile->timestep = infile->timestep

Opt = True

do ivar = 2, 69 ;30,30;34,34 ; 2, 69

  print("Processing: "+invars(ivar))
  invar = infile->$invars(ivar)$
  dimnames = getfilevardimnames(infile,invars(ivar))
  dimlen   = dimsizes(invar)

  outvar      = ESMF_regrid_with_weights(invar,weights_nearest,Opt)
  outvar_veg  = ESMF_regrid_with_weights(invar,weights_nearest_veg,Opt)
  outvar_bare = ESMF_regrid_with_weights(invar,weights_nearest_bare,Opt)
  outvar_snow = ESMF_regrid_with_weights(invar,weights_nearest_snow,Opt)

  if(dimsizes(dimlen).gt.2) then

    do ilev = 0, dimlen(1)-1

      print(num(outvar(0,ilev,:) .gt. 1e19))
      print(num(outvar(0,ilev,:) .gt. 1e19 .and. (vegtype.ne.15.and.vegtype.ne.16)))
      print(num(outvar(0,ilev,:) .gt. 1e19 .and. (vegtype.eq.15)))
      print(num(outvar(0,ilev,:) .gt. 1e19 .and. (vegtype.eq.16)))

      outvar(0,ilev,:) = where(vegtype.ne.15 .and. vegtype.ne.16, outvar_veg(0,ilev,:), outvar(0,ilev,:))
      outvar(0,ilev,:) = where(vegtype.eq.15, outvar_snow(0,ilev,:), outvar(0,ilev,:))
      outvar(0,ilev,:) = where(vegtype.eq.16, outvar_bare(0,ilev,:), outvar(0,ilev,:))

      print(num(outvar(0,ilev,:).gt.1e19))
      print(num(outvar(0,ilev,:) .gt. 1e19 .and. (vegtype.ne.15.and.vegtype.ne.16)))
      print(num(outvar(0,ilev,:) .gt. 1e19 .and. (vegtype.eq.15)))
      print(num(outvar(0,ilev,:) .gt. 1e19 .and. (vegtype.eq.16)))

    end do

  else

    print(num(outvar(0,:) .gt. 1e19))
    print(num(outvar(0,:) .gt. 1e19 .and. (vegtype.ne.15.and.vegtype.ne.16)))
    print(num(outvar(0,:) .gt. 1e19 .and. (vegtype.eq.15)))
    print(num(outvar(0,:) .gt. 1e19 .and. (vegtype.eq.16)))

    outvar(0,:) = where(vegtype.ne.15 .and. vegtype.ne.16, outvar_veg(0,:), outvar(0,:))
    outvar(0,:) = where(vegtype.eq.15, outvar_snow(0,:), outvar(0,:))
    outvar(0,:) = where(vegtype.eq.16, outvar_bare(0,:), outvar(0,:))

    print(num(outvar(0,:) .gt. 1e19))
    print(num(outvar(0,:) .gt. 1e19 .and. (vegtype.ne.15.and.vegtype.ne.16)))
    print(num(outvar(0,:) .gt. 1e19 .and. (vegtype.eq.15)))
    print(num(outvar(0,:) .gt. 1e19 .and. (vegtype.eq.16)))

  end if

  outvar!1 = dimnames(1)
  if(dimsizes(dimlen).gt.2) then
    outvar!2 = dimnames(2)
  end if
  delete(outvar@lat1d)
  delete(outvar@lon1d)

  outfile->$invars(ivar)$ = outvar

  delete(invar)
  delete(outvar)
  delete(outvar_veg)
  delete(outvar_bare)
  delete(outvar_snow)
  delete(dimnames)
  delete(dimlen)

end do

end

